clear all;
% Parameter
L=2;
sample_s=zeros(10,15);
delta_=2000;
runs=20;
d=5;
test_max=20;


for j=1:15

    for i=1:10
        N0 = i*delta_; % sampling number
        K = 3;    % number of nodes in hidden layer

        loop_n = 10000;

        eta = 2; % stepsize of gradient descent

        count=0;
        for test=1:test_max
            %  mix-gaussian parameter

            x_1=randn(d, N0*0.5)+1;
            x_2=(10^(j*0.2-1.6))*randn(d, N0*0.5)-1;
            x_N=cat(2,x_1,x_2);
            r=randperm(size(x_N,2));
            x_N=x_N(:,r);
            % Generate W

            W = 1 * randn( d, K );

            % Algorithm
      
            [H_matrix, H_FCN] = Conv_sigmoid_FCN( x_N, W );
            y_N=zeros(1,N0);

            for ind=1:N0
                y_N(ind)=binornd(1,H_FCN(ind));
            end
            W_out=zeros(d*K,runs);
            for run=1:runs
                temp = randn( d , K );
                W_0 = W + 0.1 * norm( W , 'fro' ) * temp / norm( temp ,  'fro' );
                W_t0=W_0;
                eta=2;
                for l = 1 : loop_n
           
                    GD=Gradient_crossentropy(x_N,y_N,W_t0);
                    W_t = W_t0 - eta * GD;
                    %{
                    errit( l ) = norm( W-W_t , 'fro') / norm( W , 'fro');
                    if isnan(errit(l))
                        break;
                    end
                    %}
                    W_t0=W_t;
                end
                W_out(:,run)=W_t(:);
            end
            w_bar=mean(W_out,2);
            W_bar=ones(d*K,runs).*w_bar;
            Error=norm(W_bar-W_out,'fro')/sqrt(runs);
            if Error<=1e-3
               count=count+1;
            end
        end
        sample_s(11-i,j)=count/test_max;
    end
end


